// ==UserScript==
// @name         5ch オリジナルポップアップ （表示スクリプト）
// @namespace    http://tampermonkey.net/
// @version      2.2
// @description  >>アンカー・+Nホバー時にレスをまとめて表示、即消し＆ダブルクリックでジャンプ対応（最適化版）
// @match        *://*.5ch.net/test/read.cgi/*
// @grant        none
// @run-at       document-end
// ==/UserScript==

(function () {
    'use strict';

    // jQueryロード待機と実行
    function waitForjQuery(callback) {
        if (window.jQuery) return callback(window.jQuery);
        const script = document.createElement('script');
        script.src = 'https://code.jquery.com/jquery-3.6.0.min.js';
        script.onload = () => callback(window.jQuery.noConflict(true));
        document.head.appendChild(script);
    }

    waitForjQuery(($) => {

        const popupStack = [];
        window.popupStack = popupStack;

        // CSS挿入
        $('<style>').prop('type', 'text/css').html(`
            span.custom_reply {
                color: #2F71BC !important;
                cursor: pointer;
                text-decoration: none;
            }
            span.custom_reply:hover {
                text-decoration: underline;
            }
            .popup-box {
                max-height: 60vh;
                overflow-y: auto;
                position: absolute;
                border: 1px solid #666;
                background-color: #212121;
                color: #ddd;
                max-width: 600px;
                padding: 6px;
                border-radius: 6px;
                box-shadow: 0 4px 12px rgba(0,0,0,0.3);
                z-index: 9999;
                display: none;
                user-select: text;
            }
            .popup-box a {
                color: #2F71BC !important;
                text-decoration: none;
                cursor: pointer;
            }
            .popup-box a:hover {
                text-decoration: underline;
            }
        `).appendTo('head');

        // 対象アンカーにクラスと属性を付与
        function decorateAnchors(context) {
            $(context).find('a[href^="#"]').each(function () {
                const id = this.getAttribute('href').slice(1);
                $(this).addClass('custom_reply').attr('data-post-id', id);
            });
        }

        // マウス追跡してポップアップ外を自動削除
        function setupGlobalMouseTracker() {
            setInterval(() => {
                if (!popupStack.some(p => p.popup.is(':hover') || p.trigger.is(':hover'))) {
                    popupStack.forEach(p => p.popup.remove());
                    popupStack.length = 0;
                }
            }, 300);
        }
        setupGlobalMouseTracker();

        // 投稿要素にスクロールしてハイライト
        function scrollToAndHighlight(postId) {
            const target = document.querySelector(`[data-id="${postId}"]`);
            if (!target) return;

            const offsetPx = 200;
            const highlightColor = 'rgba(255, 215, 0, 0.8)';
            const highlightDuration = 1500;
            const rect = target.getBoundingClientRect();
            const absoluteTop = window.scrollY + rect.top;

            window.scrollTo({ top: absoluteTop - offsetPx, behavior: 'smooth' });

            target.style.position = 'relative';
            target.style.zIndex = '10';
            target.style.transition = 'box-shadow 0.5s ease-in-out, border-color 0.3s ease';
            target.style.borderBottom = 'none';
            target.style.boxShadow = `inset 0 -1px 0 0 #eee, 0 0 12px 4px ${highlightColor}`;

            setTimeout(() => {
                target.style.boxShadow = '';
                target.style.borderBottom = '1px solid #eee';
                target.style.borderColor = 'transparent';
            }, highlightDuration);

            setTimeout(() => {
                target.style.borderColor = 'rgb(238, 238, 238)';
                target.style.position = '';
                target.style.zIndex = '';
            }, highlightDuration + 500);
        }

        // ポップアップ生成＆表示
        function createPopup($trigger, postId, $content, isGrouped = false) {
            const $popup = $('<div class="popup-box"></div>').appendTo('body');

            // ポップアップ内のポップアップ要素があれば除去（重複防止）
            $content.find('.popup-box').remove();

            $popup.html($content.html());

            // id属性を data-id属性にコピー（ハイライト用）
            $popup.find('[id]').each(function () {
                $(this).attr('data-id', this.id);
            });
            $popup.attr('data-post-id', postId);

            // マウス座標 or トリガーのオフセットを基準にポジション決定
            let mouseX = window.lastMouseEvent?.pageX ?? $trigger.offset().left;
            let mouseY = window.lastMouseEvent?.pageY ?? $trigger.offset().top;

            // 複数ポップアップ時のズレ
            const offsetStep = 25;
            const idx = popupStack.length;
            let left = mouseX + 15 + offsetStep * idx;
            let top = mouseY - 5 + offsetStep * idx;

            // 画面端はみ出し防止
            const ww = $(window).width();
            const wh = $(window).height();
            const scrollTop = $(window).scrollTop();
            const windowBottom = scrollTop + wh;

            $popup.css({ visibility: 'hidden', display: 'block', maxHeight: '', overflowY: 'visible' });
            const pw = $popup.outerWidth();
            const ph = $popup.outerHeight();
            $popup.css({ display: 'none', visibility: 'visible', maxHeight: '60vh', overflowY: 'auto' });

            if (left + pw > ww - 10) left = ww - pw - 10;
            if (left < 10) left = 10;

            if (top + ph > windowBottom - 20) top = windowBottom - ph - 20;
            if (top < scrollTop + 10) top = scrollTop + 10;

            $popup.css({ top, left }).fadeIn(100);

            decorateAnchors($popup);

            popupStack.push({ popup: $popup, trigger: $trigger });

            // ポップアップから離れたら消す
            $popup.off('mouseleave.latestPopup').on('mouseleave.latestPopup', () => {
                if (popupStack.length && popupStack[popupStack.length - 1].popup.is($popup)) {
                    $popup.remove();
                    popupStack.pop();
                }
            });
        }
        window.createPopup = createPopup;

        // スレッドID、板名、サーバ取得
        function getThreadId() {
            const m = location.pathname.match(/\/read\.cgi\/[^/]+\/(\d+)/);
            return m ? m[1] : null;
        }
        function getBoardName() {
            const m = location.pathname.match(/\/read\.cgi\/([^/]+)\//);
            return m ? m[1] : null;
        }
        function getServerHost() {
            return location.host;
        }

        // ポップアップ用レス読み込み（キャッシュ先行、なければGET）
        function loadAndPopup($trigger, postId, isGrouped = false, $groupContainer = null) {
            // 既に同じpostIdのポップアップがあれば削除して重複防止
            for (let i = popupStack.length - 1; i >= 0; i--) {
                if (popupStack[i].popup.attr('data-post-id') === postId) {
                    popupStack[i].popup.remove();
                    popupStack.splice(i, 1);
                }
            }

            const $target = $('#threadcontent').find('#' + postId).not('.popup-box *').first();

            if ($target.length) {
                const $clone = $target.clone(true, true).find('.hoverAppend').remove().end();

                if (isGrouped && $groupContainer) {
                    $groupContainer.append($clone);
                } else {
                    createPopup($trigger, postId, $clone);
                }
            } else {
                const threadId = getThreadId();
                const board = getBoardName();
                const server = getServerHost();
                if (!threadId || !board || !server) return;

                const url = `https://${server}/test/read.cgi/${board}/${threadId}/${postId}`;
                $.get(url, html => {
                    const $html = $(html);
                    const $res = $html.find(`#${postId}`);
                    if ($res.length) {
                        const $clone = $res.clone();

                        if (isGrouped && $groupContainer) {
                            $groupContainer.append($clone);
                        } else {
                            createPopup($trigger, postId, $clone);
                        }
                    }
                });
            }
        }
        window.loadAndPopup = loadAndPopup;

        // ページ初期化時に>>数字のspanをカスタムアンカー化
        $('span').each(function () {
            const m = $(this).text().match(/>>(\d+)/);
            if (m) $(this).addClass('custom_reply').attr('data-post-id', m[1]);
        });

        // >>アンカー ホバー時にポップアップ
        $(document).on('mouseenter', 'span.custom_reply, .popup-box a.custom_reply', function () {
            const $el = $(this);
            const postId = $el.data('post-id') || ($el.text().match(/>>(\d+)/) || [])[1];
            if (!postId) return;
            loadAndPopup($el, postId);
        });

        // +Nアンカークリックで複数レスまとめてポップアップ表示
        $(document).on('click', '.mention-count', function () {
            const $mention = $(this);
            let postIds = $mention.data('mentionPostIds');
            if (typeof postIds === 'string') {
                try { postIds = JSON.parse(postIds); } catch { return; }
            }
            if (!Array.isArray(postIds) || !postIds.length) return;

            postIds.sort((a, b) => a - b);
            const $groupContainer = $('<div></div>');

            postIds.forEach(pid => loadAndPopup($mention, pid, true, $groupContainer));

            setTimeout(() => {
                if ($groupContainer.children().length) createPopup($mention, postIds[0], $groupContainer, true);
            }, 150);
        });

        // ポップアップ内カスタムアンカークリックはスクロール＆ハイライト
        $(document).on('click', '.popup-box a.custom_reply', function (e) {
            e.preventDefault();
            const href = $(this).attr('href');
            if (!href || href[0] !== '#') return;
            const targetId = href.slice(1);
            if ($('#' + targetId).length) scrollToAndHighlight(targetId);
        });

        // ポップアップダブルクリックで元レスにスクロール＆ハイライト
        $(document).on('dblclick', '.popup-box', function () {
            const postId = $(this).attr('data-post-id');
            if (postId) scrollToAndHighlight(postId);
        });

        // IDから同一IDの投稿をまとめてポップアップ表示
        function createPopupFromId($trigger, idText) {
            if (!idText.startsWith('ID:')) idText = 'ID:' + idText;
            const $matchedPosts = $('div.post').filter((_, el) => $(el).data('userid') === idText);
            if (!$matchedPosts.length) return;

            const $groupContainer = $('<div></div>');
            $matchedPosts.each((_, el) => {
                const $clone = $(el).clone(true, true).find('.hoverAppend').remove().end();
                $groupContainer.append($clone);
            });
            createPopup($trigger, 'uid-popup', $groupContainer, true);
        }
        window.createPopupFromId = createPopupFromId;

        // UIDクリックで同一UIDの投稿をまとめてポップアップ（関数化して呼び出し）
        $(document).on('click', 'span.uid', function () {
            const uidText = $(this).text().trim();
            if (!uidText.startsWith('ID:')) return;
            createPopupFromId($(this), uidText);
        });

        // +/n ラベルクリックで同一IDの投稿まとめて表示
        $(document).on('click', 'span.userid-count-label', function () {
            const userId = $(this).data('userid');
            if (!userId) return;
            createPopupFromId($(this), userId);
        });

        // ﾜｯﾁｮｲクリックで同一トリップコード投稿まとめてポップアップ
        $(document).on('click', 'span.postusername', function () {
            const text = $(this).text();
            const match = text.match(/([A-Za-z0-9!-/:-@¥[-`{-~]{4})-([A-Za-z0-9!-/:-@¥[-`{-~]{4})/);
            if (!match) return;
            const tripcode = match[0];

            // 重複ポップアップ削除
            for (let i = popupStack.length - 1; i >= 0; i--) {
                if (popupStack[i].trigger.text().includes(tripcode)) {
                    popupStack[i].popup.remove();
                    popupStack.splice(i, 1);
                }
            }
            createPopupFromTrip($(this), tripcode);
        });

        // トリップコードからポップアップ生成
        function createPopupFromTrip($trigger, tripcode) {
            const $groupContainer = $('<div></div>');
            const matchedPosts = [];

            $('.post').each(function () {
                const usernameText = $(this).find('span.postusername').text();
                if (usernameText.includes(tripcode)) {
                    matchedPosts.push(this);
                    $groupContainer.append($(this).clone(true, true));
                }
            });

            if (matchedPosts.length) {
                createPopup($trigger, tripcode, $groupContainer, true);
            } else {
                console.warn('No matched posts found for tripcode:', tripcode);
            }
        }
        window.createPopupFromTrip = createPopupFromTrip;

        // popup-trip/post-tripクリック時にトリップコードでポップアップ表示
        $(document).on('click', 'span.popup-trip, span.post-trip', function () {
            const tripcode = $(this).data('trip');
            if (!tripcode) return;

            for (let i = popupStack.length - 1; i >= 0; i--) {
                if (popupStack[i].trigger.text().includes(tripcode)) {
                    popupStack[i].popup.remove();
                    popupStack.splice(i, 1);
                }
            }
            createPopupFromTrip($(this), tripcode);
        });

        // マウス座標をグローバル保存（ポップアップ位置計算に使用）
        $(document).on('mousemove', e => {
            window.lastMouseEvent = e;
        });

    });
})();
